using CRM007.CRM.SDK.Core;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Client;
using System;
using System.Diagnostics;
using System.Collections.Generic;
using VRM.Integration.Servicebus.Core;
using VIMT.VirtualMeetingRoom.Messages;
using VRM.Integration.Servicebus.Logging.CRM.Util;
using VIMT.VirtualMeetingRoom.Services;
using VIMT.VirtualMeetingRoom.Services.Vyopta.UcManager;
 using Logger = VRM.Integration.Servicebus.Core.Logger;
namespace VIMT.VirtualMeetingRoom.Processors
{
	class ScheduleMeetingProcessor 
	{
	/// <summary>
	/// VIMT Enterprise Component for VIMT.VirtualMeetingRoom,ScheduleMeeting method, Processpr.
	/// Code Generated by IMS on: 4/12/2016 6:51:29 PM
	/// Version: 2016.04.08
	/// </summary>
	/// <param name=none></param>
	/// <returns>none</returns>
		public IMessageBase Execute(VIMTVyoptaSMScheduleMeetingRequest request)
		{
			//var request = message as ScheduleMeetingRequest;
			VIMTVyoptaSMScheduleMeetingResponse response = null;
			var progressString = "Top of Processor";
			try
			{
				if (request == null)
				{
					Logger.Instance.Warn(string.Format("{0} recieved a null message", GetType().FullName));
				}
				else
				{
				#region do legacy webservice calls
					string method = "ScheduleMeetingProcessor", webService = "ScheduleMeeting";
					
					var ScheduleMeetingResponse = new ScheduleMeetingResponse();
					Stopwatch thisTimer = Stopwatch.StartNew();
						
					try
					{
						SoapLog.Current.Active = true;
							var ScheduleMeetingRequestData = new ScheduleMeetingRequest();
							if(!string.IsNullOrEmpty(request.schedulemeetingrequestInfo.mcs_EncounterId)) ScheduleMeetingRequestData.EncounterId = request.schedulemeetingrequestInfo.mcs_EncounterId;
							ScheduleMeetingRequestData.EndTime = request.schedulemeetingrequestInfo.mcs_EndTime;
							if(!string.IsNullOrEmpty(request.schedulemeetingrequestInfo.mcs_GuestName)) ScheduleMeetingRequestData.GuestName = request.schedulemeetingrequestInfo.mcs_GuestName;
							if(!string.IsNullOrEmpty(request.schedulemeetingrequestInfo.mcs_GuestPin)) ScheduleMeetingRequestData.GuestPin = request.schedulemeetingrequestInfo.mcs_GuestPin;
							if(!string.IsNullOrEmpty(request.schedulemeetingrequestInfo.mcs_HostName)) ScheduleMeetingRequestData.HostName = request.schedulemeetingrequestInfo.mcs_HostName;
							if(!string.IsNullOrEmpty(request.schedulemeetingrequestInfo.mcs_HostPin)) ScheduleMeetingRequestData.HostPin = request.schedulemeetingrequestInfo.mcs_HostPin;
							if(!string.IsNullOrEmpty(request.schedulemeetingrequestInfo.mcs_MeetingRoomName)) ScheduleMeetingRequestData.MeetingRoomName = request.schedulemeetingrequestInfo.mcs_MeetingRoomName;
							if(!string.IsNullOrEmpty(request.schedulemeetingrequestInfo.mcs_MiscData)) ScheduleMeetingRequestData.MiscData = request.schedulemeetingrequestInfo.mcs_MiscData;
							ScheduleMeetingRequestData.StartTime = request.schedulemeetingrequestInfo.mcs_StartTime;
						var service = ServiceFactory.GetVirtualMeetingRoomWebServiceReference();
						
						ScheduleMeetingResponse = service.ScheduleMeeting(ScheduleMeetingRequestData);
					    Logger.Instance.Info($"The call to Vyopta took {thisTimer.ElapsedMilliseconds} ms");
					    thisTimer.Stop();
                    }
					catch (Exception ex)
					{
						thisTimer.Stop();
						
                        Logger.Instance.Error($"There was an error calling Vyopta First Catch: {ex.Message}", ex);

						if (response == null) response = new VIMTVyoptaSMScheduleMeetingResponse();
						var messageTest = ex.Message.ToLower();
						if (messageTest.Contains("no records"))
						{
							return response;
						}
						if (messageTest.Contains("shareexception"))
						{
							response.ExceptionOccured = true;
							response.ExceptionMessage = messageTest;
							return response;
						}
						if (messageTest.Contains("access violation"))
						{
							response.ExceptionOccured = true;
							response.ExceptionMessage = messageTest;
							return response;
						}
						if (messageTest.Contains("sensitive"))
						{
							response.ExceptionOccured = true;
							response.ExceptionMessage = messageTest;
							return response;
						}
						
						response.ExceptionOccured = true;
						response.ExceptionMessage = messageTest;
						return response;
					}
						
					progressString = "Before Mapping";
					try
					{
						response = new VIMTVyoptaSMScheduleMeetingResponse();
						//ScheduleMeetingResponse Mapping 
						#region  ScheduleMeetingResponse Mapping 
						var VIMTVyoptaSMScheduleMeetingResponseDataInfo  = new VIMTVyoptaSMScheduleMeetingResponseData();
						VIMTVyoptaSMScheduleMeetingResponseDataInfo.mcs_DialingAlias = ScheduleMeetingResponse.DialingAlias;
						progressString = "ScheduleMeetingResponse.DialingAlias";
						VIMTVyoptaSMScheduleMeetingResponseDataInfo.mcs_EncounterId = ScheduleMeetingResponse.EncounterId;
						progressString = "ScheduleMeetingResponse.EncounterId";
						VIMTVyoptaSMScheduleMeetingResponseDataInfo.mcs_MiscData = ScheduleMeetingResponse.MiscData;
						progressString = "ScheduleMeetingResponse.MiscData";
						response.VIMTVyoptaSMScheduleMeetingResponseDataInfo = VIMTVyoptaSMScheduleMeetingResponseDataInfo;
						progressString = "After ScheduleMeetingResponse Mapping";
						
						//passing to parentDTOName smr
						//No records existed beyond parent 
						#endregion
					}
					catch (Exception ex)
					{
					    Logger.Instance.Error($"There was an error calling Vyopta Second Catch: {ex.Message}", ex);
                        if (response == null) response = new VIMTVyoptaSMScheduleMeetingResponse();
					    response.ExceptionOccured = true;
					    response.ExceptionMessage = ex.Message;
					    return response;
					}
				#endregion
			}
			return response;
			}
			catch (Exception ex)
			{
			    Logger.Instance.Error($"There was an error calling Vyopta Third Catch: {ex.Message}", ex);

                if (response == null) response = new VIMTVyoptaSMScheduleMeetingResponse();
				response.ExceptionOccured = true;
				response.ExceptionMessage = ex.Message;
				return response;
			}
		}
	}
}